/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class VWDataDictionary {
    public static final int QUEUE_USER_CENTRIC = 1;
    public static final int QUEUE_WORK_QUEUE = 2;
    public static final int QUEUE_COMPONENT_QUEUE = 4;
    public static final int PROCESSOR_LAUNCH = 0;
    public static final int PROCESSOR_STEP = 1;
    private VWSystemConfiguration m_sysConfig = null;
    private VWSessionInfo m_sessionInfo = null;
    private VWStepProcessorInfoDefinition[] m_regularStepProcessors = null;
    private VWStepProcessorInfoDefinition m_defaultRegularStepProcessor = null;
    private VWStepProcessorInfoDefinition[] m_launchStepProcessors = null;
    private VWStepProcessorInfoDefinition m_defaultLaunchStepProcessor = null;

    public VWDataDictionary(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.retrieveSystemConfiguration();
    }

    public VWDataDictionary(VWSessionInfo sessionInfo, VWSystemConfiguration sysConfig) {
        this.m_sessionInfo = sessionInfo;
        this.m_sysConfig = sysConfig;
    }

    public VWSystemConfiguration getSystemConfiguration() {
        if (this.m_sysConfig == null) {
            this.retrieveSystemConfiguration();
        }
        return this.m_sysConfig;
    }

    public VWSystemConfiguration refetchSystemConfiguration(boolean bRetrieveFromServer) throws VWException {
        this.m_sysConfig = null;
        if (bRetrieveFromServer) {
            this.retrieveSystemConfiguration();
        } else {
            VWSession vwSession = null;
            if (this.m_sessionInfo != null) {
                vwSession = this.m_sessionInfo.getSession();
            }
            this.m_sysConfig = VWClassFactory.createVWSystemConfiguration(vwSession, false, 234L);
        }
        return this.m_sysConfig;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }

    public VWApplicationSpaceDefinition[] getApplicationSpaces() {
        try {
            Object[] appSpaceDefs;
            if (this.m_sysConfig != null && (appSpaceDefs = this.m_sysConfig.getApplicationSpaceDefinitions()) != null) {
                VWQubbleSort.sort(appSpaceDefs);
                return appSpaceDefs;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWApplicationSpaceDefinition getApplicationSpace(String appSpaceName) {
        try {
            if (this.m_sysConfig != null) {
                return this.m_sysConfig.getApplicationSpaceDefinition(appSpaceName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWQueueDefinition[] getQueueDefinitions(int nTypes) {
        try {
            VWQueueDefinition[] queueDefs;
            if (this.m_sysConfig != null && (queueDefs = this.m_sysConfig.getQueueDefinitions()) != null) {
                Vector<VWQueueDefinition> tmpList = new Vector<VWQueueDefinition>();
                for (int nIndex = 0; nIndex < queueDefs.length; ++nIndex) {
                    boolean bAddToList = false;
                    switch (queueDefs[nIndex].getQueueType()) {
                        case 2: {
                            if ((nTypes & 1) != 1) break;
                            bAddToList = true;
                            break;
                        }
                        case 1: {
                            if ((nTypes & 4) == 4) {
                                if (!queueDefs[nIndex].getIsConnectorQueue()) break;
                                bAddToList = true;
                                break;
                            }
                            if ((nTypes & 2) != 2 || queueDefs[nIndex].getIsConnectorQueue()) break;
                            bAddToList = true;
                        }
                    }
                    if (!bAddToList) continue;
                    tmpList.addElement(queueDefs[nIndex]);
                }
                if (tmpList.size() > 0) {
                    Object[] queueDefArray = new VWQueueDefinition[tmpList.size()];
                    tmpList.copyInto(queueDefArray);
                    VWQubbleSort.sort(queueDefArray);
                    return queueDefArray;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWQueueDefinition getQueueDefinition(String queueName) {
        try {
            VWQueue vwQueue;
            if (this.m_sysConfig != null) {
                return this.m_sysConfig.getQueueDefinition(queueName);
            }
            if (this.m_sessionInfo != null && (vwQueue = this.m_sessionInfo.getSession().getQueue(queueName)) != null) {
                return vwQueue.fetchQueueDefinition();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public String[] getQueueNames(int nTypes) {
        try {
            VWQueueDefinition[] queueDefs;
            if (this.m_sysConfig != null && (queueDefs = this.getQueueDefinitions(nTypes)) != null && queueDefs.length > 0) {
                String[] names = new String[queueDefs.length];
                for (int nIndex = 0; nIndex < queueDefs.length; ++nIndex) {
                    names[nIndex] = queueDefs[nIndex].getName();
                }
                return names;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWWorkBasketDefinition[] getWorkBasketDefinitions() {
        try {
            if (this.m_sysConfig != null) {
                Vector<VWWorkBasketDefinition> wbDefList = new Vector<VWWorkBasketDefinition>();
                VWQueueDefinition[] queueDefs = this.m_sysConfig.getQueueDefinitions();
                if (queueDefs != null) {
                    for (int nIndex = 0; nIndex < queueDefs.length; ++nIndex) {
                        VWWorkBasketDefinition[] workBasketDefs = queueDefs[nIndex].getWorkBasketDefinitions();
                        if (workBasketDefs == null) continue;
                        for (int nCounter = 0; nCounter < workBasketDefs.length; ++nCounter) {
                            wbDefList.addElement(workBasketDefs[nCounter]);
                        }
                    }
                }
                if (wbDefList.size() > 0) {
                    Object[] wbDefs = new VWWorkBasketDefinition[wbDefList.size()];
                    wbDefList.copyInto(wbDefs);
                    return wbDefs;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public String[] getEventLogNames() {
        try {
            if (this.m_sysConfig != null) {
                VWLogDefinition[] logDefs = this.m_sysConfig.getLogDefinitions();
                if (logDefs != null && logDefs.length > 0) {
                    String[] names = new String[logDefs.length];
                    for (int nIndex = 0; nIndex < logDefs.length; ++nIndex) {
                        names[nIndex] = logDefs[nIndex].getName();
                    }
                    return names;
                }
            } else if (this.m_sessionInfo != null) {
                return this.m_sessionInfo.getSession().fetchEventLogNames();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWLogDefinition getEventLogDefinition(String eventLogName) {
        try {
            if (this.m_sysConfig != null) {
                return this.m_sysConfig.getLogDefinition(eventLogName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public String[] getRosterNames() {
        try {
            if (this.m_sysConfig != null) {
                VWRosterDefinition[] rosterDefs = this.m_sysConfig.getRosterDefinitions();
                if (rosterDefs != null && rosterDefs.length > 0) {
                    String[] names = new String[rosterDefs.length];
                    for (int nIndex = 0; nIndex < rosterDefs.length; ++nIndex) {
                        names[nIndex] = rosterDefs[nIndex].getName();
                    }
                    return names;
                }
            } else if (this.m_sessionInfo != null) {
                return this.m_sessionInfo.getSession().fetchRosterNames(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWRosterDefinition getRosterDefinition(String rosterName) {
        try {
            if (this.m_sysConfig != null) {
                return this.m_sysConfig.getRosterDefinition(rosterName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWStepProcessorInfoDefinition[] getStepProcessors(int nType) {
        try {
            if (this.m_sysConfig != null) {
                Object[] spInfoDefs = this.m_sysConfig.getStepProcessorInfoDefinitions();
                if (spInfoDefs != null && spInfoDefs.length > 0) {
                    Vector<Object> spItems = new Vector<Object>();
                    block10: for (int nIndex = 0; nIndex < spInfoDefs.length; ++nIndex) {
                        switch (spInfoDefs[nIndex].getProcessorType()) {
                            case 1: 
                            case 4: {
                                if (nType != 0) continue block10;
                                spItems.addElement(spInfoDefs[nIndex]);
                                continue block10;
                            }
                            case 2: 
                            case 8: {
                                if (nType != 1) continue block10;
                                spItems.addElement(spInfoDefs[nIndex]);
                            }
                        }
                    }
                    if (spItems.size() > 0) {
                        spInfoDefs = new VWStepProcessorInfoDefinition[spItems.size()];
                        spItems.copyInto(spInfoDefs);
                        return spInfoDefs;
                    }
                }
            } else if (this.m_sessionInfo != null) {
                switch (nType) {
                    case 0: {
                        if (this.m_launchStepProcessors == null) {
                            this.fetchStepProcessorInfo(5);
                        }
                        if (this.m_launchStepProcessors != null && this.m_launchStepProcessors.length > 0) {
                            VWStepProcessorInfoDefinition[] launchSPArray = new VWStepProcessorInfoDefinition[this.m_launchStepProcessors.length];
                            System.arraycopy(this.m_launchStepProcessors, 0, launchSPArray, 0, this.m_launchStepProcessors.length);
                            return launchSPArray;
                        }
                    }
                    case 1: {
                        if (this.m_regularStepProcessors == null) {
                            this.fetchStepProcessorInfo(10);
                        }
                        if (this.m_regularStepProcessors == null || this.m_regularStepProcessors.length <= 0) break;
                        VWStepProcessorInfoDefinition[] regularSPArray = new VWStepProcessorInfoDefinition[this.m_regularStepProcessors.length];
                        System.arraycopy(this.m_regularStepProcessors, 0, regularSPArray, 0, this.m_regularStepProcessors.length);
                        return regularSPArray;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWStepProcessorInfoDefinition getDefaultStepProcessor(int nType) {
        try {
            if (this.m_sysConfig != null) {
                VWStepProcessorInfoDefinition[] spInfoDefs = this.m_sysConfig.getStepProcessorInfoDefinitions();
                if (spInfoDefs != null && spInfoDefs.length > 0) {
                    block10: for (int nIndex = 0; nIndex < spInfoDefs.length; ++nIndex) {
                        switch (spInfoDefs[nIndex].getProcessorType()) {
                            case 1: {
                                if (nType != 0) continue block10;
                                return spInfoDefs[nIndex];
                            }
                            case 2: {
                                if (nType != 1) continue block10;
                                return spInfoDefs[nIndex];
                            }
                        }
                    }
                }
            } else if (this.m_sessionInfo != null) {
                switch (nType) {
                    case 0: {
                        if (this.m_defaultLaunchStepProcessor == null) {
                            this.fetchStepProcessorInfo(5);
                        }
                        return this.m_defaultLaunchStepProcessor;
                    }
                    case 1: {
                        if (this.m_defaultRegularStepProcessor == null) {
                            this.fetchStepProcessorInfo(10);
                        }
                        return this.m_defaultRegularStepProcessor;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean createStepProcessor(String name, int nProcessorType, Integer nWebAppId, String location) throws VWException {
        if (this.m_sysConfig == null) {
            return false;
        }
        if (name == null || name.length() == 0) {
            throw new VWException("vw.toolkit.utils.VWDataDictionaryBadStepProcessorName", "Invalid step processor name.");
        }
        if (location == null || location.length() == 0) {
            throw new VWException("vw.toolkit.utils.VWDataDictionaryBadStepProcessorLocation", "Invalid step processor URL.");
        }
        VWStepProcessorInfoDefinition spInfoDef = this.m_sysConfig.getStepProcessorInfoDefinition(name);
        if (spInfoDef != null) {
            throw new VWException("vw.toolkit.utils.VWDataDictionaryStepProcessorExists", "A step processor with that name already exists.");
        }
        spInfoDef = this.m_sysConfig.createStepProcessorInfoDefinition();
        spInfoDef.setName(name);
        spInfoDef.setHasChanged(true);
        spInfoDef.setHeight(600);
        spInfoDef.setWidth(800);
        spInfoDef.setProcessorType(nProcessorType);
        spInfoDef.setAppType(32);
        Hashtable<Integer, String> locationTable = new Hashtable<Integer, String>();
        locationTable.put(nWebAppId, location);
        spInfoDef.setLocations(locationTable);
        return true;
    }

    public Hashtable getWebApplications() {
        Hashtable webAppTable = new Hashtable();
        try {
            if (this.m_sessionInfo != null) {
                VWSystemAdministration sysAdmin = this.m_sessionInfo.getSession().fetchSystemAdministration();
                this.addWebApplications(webAppTable, sysAdmin.getAttributeInfo());
            }
            this.addWebApplications(webAppTable, this.m_sysConfig.getAttributeInfo());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return webAppTable;
    }

    private void retrieveSystemConfiguration() {
        try {
            if (this.m_sysConfig == null && this.m_sessionInfo != null) {
                this.m_sysConfig = this.m_sessionInfo.getSession().fetchSystemConfiguration();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void fetchStepProcessorInfo(int nFlags) {
        try {
            VWSession vwSession = this.m_sessionInfo.getSession();
            if (vwSession != null) {
                VWStepProcessorInfo[] stepProcessors = vwSession.fetchStepProcessors(nFlags);
                if (stepProcessors != null) {
                    int i;
                    Vector<VWStepProcessorInfoDefinition> validStepProcessors = new Vector<VWStepProcessorInfoDefinition>();
                    boolean bFullP8Functionality = this.m_sessionInfo.getDisplayP8BPMFunctionality();
                    for (i = 0; i < stepProcessors.length; ++i) {
                        Hashtable locationTable = stepProcessors[i].getLocations();
                        if (locationTable == null || locationTable.isEmpty()) continue;
                        boolean bAdd = false;
                        Enumeration keyEnum = locationTable.keys();
                        while (keyEnum.hasMoreElements()) {
                            int nWebAppId = (Integer)keyEnum.nextElement();
                            if (this.m_sessionInfo.isP8WebApp(nWebAppId)) {
                                if (!bFullP8Functionality) continue;
                                bAdd = true;
                                continue;
                            }
                            bAdd = true;
                        }
                        if (!bAdd) continue;
                        validStepProcessors.addElement(new VWStepProcessorInfoDefinition(stepProcessors[i]));
                    }
                    for (i = 0; i < validStepProcessors.size(); ++i) {
                        VWStepProcessorInfoDefinition stepProcessorInfoDef = (VWStepProcessorInfoDefinition)validStepProcessors.elementAt(i);
                        if (stepProcessorInfoDef == null || !stepProcessorInfoDef.isDefaultType()) continue;
                        if ((nFlags & 4) == 4) {
                            this.m_defaultLaunchStepProcessor = stepProcessorInfoDef;
                            break;
                        }
                        this.m_defaultRegularStepProcessor = stepProcessorInfoDef;
                        break;
                    }
                    if ((nFlags & 4) == 4) {
                        this.m_launchStepProcessors = new VWStepProcessorInfoDefinition[validStepProcessors.size()];
                        validStepProcessors.copyInto(this.m_launchStepProcessors);
                    } else {
                        this.m_regularStepProcessors = new VWStepProcessorInfoDefinition[validStepProcessors.size()];
                        validStepProcessors.copyInto(this.m_regularStepProcessors);
                    }
                } else {
                    System.out.println("[" + VWResource.s_stepProcessorError + "] - " + VWResource.s_noStepProcessor);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addWebApplications(Hashtable hTable, VWAttributeInfo attributeInfo) {
        try {
            String[] names = attributeInfo.getAttributeNames();
            if (names != null) {
                for (int nIndex = 0; nIndex < names.length; ++nIndex) {
                    int nId;
                    if (!names[nIndex].startsWith("F_WebServer") || (nId = this.getIdFromKey(names[nIndex])) == -1) continue;
                    String value = (String)attributeInfo.getFieldValue(names[nIndex]);
                    hTable.put(new Integer(nId), value);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int getIdFromKey(String key) {
        try {
            StringTokenizer st;
            if (key != null && key.length() > 0 && (st = new StringTokenizer(key, ".")).hasMoreTokens()) {
                String token = st.nextToken();
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    return Integer.parseInt(token);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }
}

